# EinsatzBoard

Generische Webapp für Einsatzleitung (EL) & Gruppenführer (GF) – **multi-user**, **multi-organisation**, **Live-Updates ohne Reload** (SSE) und mit Fokus auf **Konfigurierbarkeit** (Branding, Datenschutz-Defaults, Templates).

## Ziele & Designprinzipien
- **So wenig Hardcoding wie möglich**: Branding, Farben, Logos, Datenschutzregeln, Transfer-Modus, Vorlagen etc. liegen in `app_setting` und sind per Admin-UI änderbar.
- **Datenschutz**: In der Teilnehmerliste können fremde Organisationen standardmäßig pseudonymisiert werden (einstellbar).
- **Multiuser**: Session-basierte Auth mit Rollen (admin/el/gf).
- **Live**: Server-Sent Events (`/events`) verteilt Änderungen an alle Clients.

## Setup

### 1) DB anlegen
Erstelle eine leere PostgreSQL-Datenbank (z. B. `einsatzboard`).

### 2) Config
```bash
cp app/config.sample.php app/config.php
# in app/config.php DSN/user/pass anpassen
```

### 3) Install (Migration + Seed)
```bash
php bin/install.php
```
Seed-Login: **admin / admin123** (bitte sofort ändern – dafür ist bereits eine Admin-Seite vorbereitet).

### 4) Lokaler Start
```bash
php -S 127.0.0.1:8080 -t public
```
Dann öffnen: `http://127.0.0.1:8080/`

## Funktionen (MVP)
- Einsätze anlegen & verwalten
- Teilnehmer Check-In / Check-Out (einzeln & alle)
- Teilnehmerübersicht inkl. Fähigkeiten (Capabilities als JSON)
- Teams anlegen, Mitglieder zuweisen
- Aufträge anlegen, Status ändern, Notizen
- Angebotsbasierte Transfers (Auftrag-Transfer / Mitglieder-Ausleihe) inkl. „annehmen/ablehnen“
- Interner Chat (basic) inkl. Scope (public/org/gfs)
- Admin-Settings: Branding (Name/Farben/Logo/Favicon), Privacy, Ops-Defaults

## Nächste sinnvolle Erweiterungen
- Benutzer- & Organisationsverwaltung im UI (aktuell nur DB/Seed)
- Feinere Rechte (z. B. pro Einsatz, pro Modul)
- Auftrag-Templates UI (Schema-Builder)
- Nachbereitung: Export, Bericht, Statistik, Audit-Filter
- Offline/Degraded-Mode (wenn andere Orgs nicht reagieren: Auto-Timeout-Regeln)
- Besseres Team-Assignment UI (Drag&Drop), Roles in Team (HF/Navi/Funk/...)
