<?php
declare(strict_types=1);

final class AuthController {
  public static function login(): void {
    $in = json_input();
    $u = trim((string)($in['username'] ?? ''));
    $p = (string)($in['password'] ?? '');
    if ($u === '' || $p === '') api_error(400, 'Missing username/password');
    $res = login($u, $p);
    api_json(['ok'=>true, 'user'=>$res]);
  }

  public static function logout(): void {
    require_login();
    logout();
    api_json(['ok'=>true]);
  }

  public static function me(): void {
    $u = current_user();
    // CSRF token should be available even on the login screen, so the client can perform
    // a protected login request without a second round-trip.
    api_json([
      'ok' => true,
      'user' => $u,
      'csrf' => csrf_token(),
      'settings' => public_settings(),
    ]);
  }
}
