<?php
declare(strict_types=1);

final class EventsController {
  public static function emitGlobal(string $type, array $payload): void {
    $stmt = db()->prepare('INSERT INTO app_event(id, incident_id, org_id, visibility, type, payload_json)
      VALUES (gen_random_uuid(), NULL, NULL, :vis, :type, :payload::jsonb)');
    $stmt->execute([
      ':vis' => 'all',
      ':type' => $type,
      ':payload' => json_encode($payload, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
    ]);
  }

  public static function emitIncident(string $incidentId, ?string $orgId, string $visibility, string $type, array $payload): void {
    $stmt = db()->prepare('INSERT INTO app_event(id, incident_id, org_id, visibility, type, payload_json)
      VALUES (gen_random_uuid(), :iid, :oid, :vis, :type, :payload::jsonb)');
    $stmt->execute([
      ':iid' => $incidentId,
      ':oid' => $orgId,
      ':vis' => $visibility,
      ':type' => $type,
      ':payload' => json_encode($payload, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES),
    ]);
  }

  public static function stream(): void {
    $u = require_login();

    // IMPORTANT: SSE keeps the request open. If we keep the PHP session open as well,
    // it will hold an exclusive session lock and block all other requests from the same user.
    // Closing the session here makes the UI feel instant.
    if (session_status() === PHP_SESSION_ACTIVE) {
      session_write_close();
    }

    while (ob_get_level() > 0) ob_end_flush();
    header('Content-Type: text/event-stream; charset=utf-8');
    header('Cache-Control: no-store');
    header('Connection: keep-alive');

    $last = $_SERVER['HTTP_LAST_EVENT_ID'] ?? ($_GET['lastEventId'] ?? '0');
    $last = is_numeric($last) ? (int)$last : 0;

    $pdo = db();
    $start = time();
    $timeout = 25;

    echo "event: hello\n";
    echo 'data: ' . json_encode(['ok'=>true, 'ts'=>gmdate('c')]) . "\n\n";
    @ob_flush(); @flush();

    while (true) {
      if (connection_aborted()) break;
      if (time() - $start > $timeout) break;

      $stmt = $pdo->prepare('SELECT seq, incident_id, org_id, visibility, type, payload_json, created_at
        FROM app_event
        WHERE seq > :last
        ORDER BY seq ASC
        LIMIT 200');
      $stmt->execute([':last'=>$last]);
      $rows = $stmt->fetchAll();

      foreach ($rows as $r) {
        $vis = $r['visibility'];
        if ($vis === 'org' && $r['org_id'] !== $u['org_id']) continue;
        if ($vis === 'role') {
          $pl = json_decode($r['payload_json'], true) ?: [];
          if (($pl['role'] ?? null) !== $u['role']) continue;
        }

        $last = (int)$r['seq'];
        echo 'id: ' . $last . "\n";
        echo 'event: ' . $r['type'] . "\n";
        echo 'data: ' . $r['payload_json'] . "\n\n";
      }

      echo ": ping\n\n";
      @ob_flush(); @flush();
      usleep(500000);
    }
    exit;
  }
}
