<?php
declare(strict_types=1);

function cfg(): array {
  static $cfg = null;
  if ($cfg === null) {
    $path = __DIR__ . '/../config.php';
    if (!file_exists($path)) {
      http_response_code(500);
      header('Content-Type: text/plain; charset=utf-8');
      echo "Missing app/config.php. Copy app/config.sample.php to app/config.php and configure DB.\n";
      exit;
    }
    $cfg = require $path;
  }
  return $cfg;
}

function db(): PDO {
  static $pdo = null;
  if ($pdo === null) {
    $c = cfg();
    $pdo = new PDO($c['db']['dsn'], $c['db']['user'], $c['db']['pass'], [
      PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
      PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
    // Ensure sane settings.
    $pdo->exec("SET TIME ZONE 'UTC'");
  }
  return $pdo;
}

function db_tx(callable $fn) {
  $pdo = db();
  try {
    $pdo->beginTransaction();
    $res = $fn($pdo);
    $pdo->commit();
    return $res;
  } catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    throw $e;
  }
}
